TARGET = tsf('/Users/ben/Documents/audioguide/examples/cage.aiff', thresh=-25, offsetRise=1.5)



SEARCH_PATHS = ['/Users/ben/Documents/sfdb/']


_pitched_intervals = [(0, 12), (0.7, 24)]

CORPUS = [
# short violin sounds
csf('violin/staccato/', instrTag='violin', instrParams={'technique': 'arco', 'articulation': 'staccato', 'temporal_mode': 'artic', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', wholeFile=True),
csf('violin/pizz/', instrTag='violin', instrParams={'temporal_mode': 'artic', 'minspeed': 0.15, 'technique': 'pizz','annotation': 'pizz', "interval_limit_breakpoints": _pitched_intervals, 'polyphony_max_voices': 1}, scaleDb='filenamedyn', wholeFile=True),
csf('violin/scratch/', instrTag='violin', midiPitchMethod={'type': 'file_match', 'I-': 76, 'II-': 69, 'III-': 62, 'IV-': 55}, instrParams={'technique': 'arco', 'articulation': 'staccato', 'temporal_mode': 'artic', 'polyphony_max_voices': 1, 'notehead': 'acc', 'pitched': False, 'minspeed': 0.5, 'dynamics': ['mf', 'f', 'ff']}, wholeFile=True),
# long violin sounds
csf('violin/non-vibrato/', instrTag='violin', instrParams={'technique': 'arco', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05, wholeFile=True),
csf('violin/sul-ponticello/', instrTag='violin', instrParams={'technique': 'arco', 'annotation': 'SP', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05, wholeFile=True),
csf('violin/sul-tasto/', instrTag='violin', instrParams={'technique': 'arco', 'annotation': 'ST', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05, wholeFile=True),
csf('violin/artificial-harmonic/', instrTag='violin', instrParams={'polyphony_max_voices': 1, 'technique': 'arco', 'annotation': 'harmonic', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05, wholeFile=True),

csf('/Users/ben/Documents/audioguide/corpi/glitz', restrictOverlaps=3, limit=['power-seg < 80%', 'power-seg >= 60%', 'effDur-seg < 0.4']),
]


INSTRUMENTS = score(
instr('violin', minspeed=0.08, polyphony_max_voices=2, polyphony_min_range=3, polyphony_max_range=8, polyphony_minspeed=0.4, technique_switch_delay_map=[('pizz', 'arco', 0.4), ('arco', 'pizz', 0.6)]),
)


SEARCH = [
spass('ratio_limit', d('effDur-seg'), minratio=1),
spass('closest_percent', d('power-seg'), percent=20),
spass('closest', d('mfccs-seg')),
]


SUPERIMPOSE = si()


#CSOUND_CHANNEL_RENDER_METHOD = "targetoutputmix"