TARGET = tsf('/Users/ben/Documents/audioguide/examples/cage.aiff', thresh=-25, offsetRise=1.5)
#TARGET = tsf('/Users/ben/Desktop/messy/tutorial/9-writingforinstruments/beatbox.wav', thresh=-35, minSegLen=0.05, offsetRise=2)



SEARCH_PATHS = ['/Users/ben/Documents/sfdb/']

_pitched_intervals = [(0, 5), (0.7, 18)]

CORPUS = [
# short violin sounds
csf('violin/staccato/', instrTag='violin', instrParams={'technique': 'arco', 'articulation': 'staccato', 'temporal_mode': 'artic', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn'),
csf('violin/pizz/', instrTag='violin', instrParams={'temporal_mode': 'artic', 'minspeed': 0.15, 'technique': 'pizz','annotation': 'pizz', "interval_limit_breakpoints": _pitched_intervals, 'polyphony_max_voices': 1}, scaleDb='filenamedyn'),
csf('violin/scratch/', instrTag='violin', midiPitchMethod={'type': 'file_match', 'I-': 76, 'II-': 69, 'III-': 62, 'IV-': 55}, instrParams={'technique': 'arco', 'articulation': 'staccato', 'temporal_mode': 'artic', 'polyphony_max_voices': 1, 'notehead': 'acc', 'pitched': False, 'minspeed': 0.5, 'dynamics': ['mf', 'f', 'ff']}),
# long violin sounds
csf('violin/non-vibrato/', instrTag='violin', instrParams={'technique': 'arco', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05),
csf('violin/sul-ponticello/', instrTag='violin', instrParams={'technique': 'arco', 'annotation': 'SP', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05),
csf('violin/sul-tasto/', instrTag='violin', instrParams={'technique': 'arco', 'annotation': 'ST', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05),
csf('violin/artificial-harmonic/', instrTag='violin', instrParams={'polyphony_max_voices': 1, 'technique': 'arco', 'annotation': 'harmonic', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05),



# short viola sounds
csf('viola/scratch/', instrTag='viola', midiPitchMethod={'type': 'file_match', 'I-': 76-7, 'II-': 69-7, 'III-': 62-7, 'IV-': 55-7}, instrParams={'technique': 'arco', 'articulation': 'staccato', 'temporal_mode': 'artic', 'polyphony_max_voices': 11, 'notehead': 'acc', 'pitched': False, 'minspeed': 0.5, 'dynamics': ['mf', 'f', 'ff']}),
# long viola sounds
csf('viola/non-vibrato/', instrTag='viola', instrParams={'technique': 'arco', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05),
csf('viola/sul-ponticello/', instrTag='viola', instrParams={'technique': 'arco', 'annotation': 'SP', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05),
csf('viola/sul-tasto/', instrTag='viola', instrParams={'technique': 'arco', 'annotation': 'ST', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05),
csf('viola/artificial-harmonic/', instrTag='viola', instrParams={'polyphony_max_voices': 1, 'technique': 'arco', 'annotation': 'harmonic', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05),



# short cello sounds
csf('cello/staccato/', instrTag='cello', instrParams={'technique': 'arco', 'articulation': 'staccato', 'temporal_mode': 'artic', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn'),
csf('cello/pizz/', instrTag='cello', instrParams={'temporal_mode': 'artic', 'minspeed': 0.15, 'technique': 'pizz','annotation': 'pizz', "interval_limit_breakpoints": _pitched_intervals, 'polyphony_max_voices': 1}, scaleDb='filenamedyn'),
csf('cello/scratch/', instrTag='cello', midiPitchMethod={'type': 'file_match', 'I-': 76-19, 'II-': 69-19, 'III-': 62-19, 'IV-': 55-19}, instrParams={'technique': 'arco', 'articulation': 'staccato', 'temporal_mode': 'artic', 'polyphony_max_voices': 1, 'notehead': 'acc', 'pitched': False, 'minspeed': 0.5, 'dynamics': ['mf', 'f', 'ff']}),
# long cello sounds
csf('cello/non-vibrato/', instrTag='cello', instrParams={'technique': 'arco', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05),
csf('cello/sul-ponticello/', instrTag='cello', instrParams={'technique': 'arco', 'annotation': 'SP', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05),
csf('cello/sul-tasto/', instrTag='cello', instrParams={'technique': 'arco', 'annotation': 'ST', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05),
csf('cello/artificial-harmonic/', instrTag='cello', instrParams={'polyphony_max_voices': 1, 'technique': 'arco', 'annotation': 'harmonic', "interval_limit_breakpoints": _pitched_intervals}, scaleDb='filenamedyn', clipDurationToTarget=True, wholeFileMinStart=0.05),



]



CORPUS_GLOBAL_ATTRIBUTES = {
'wholeFile': True,
#'clipDurationToTarget': True,
#'limit': ['power-seg < 40%'],
'pitchfilter': {'harmonics': ['C2'], 'tolerance': 3},
}


INSTRUMENTS = score(
instr('violin', minspeed=0.08, polyphony_max_voices=2, polyphony_min_range=3, polyphony_max_range=8, polyphony_minspeed=0.4, technique_switch_delay_map=[('pizz', 'arco', 0.4), ('arco', 'pizz', 0.6)]),
instr('violin', minspeed=0.08, polyphony_max_voices=2, polyphony_min_range=3, polyphony_max_range=8, polyphony_minspeed=0.4, technique_switch_delay_map=[('pizz', 'arco', 0.4), ('arco', 'pizz', 0.6)]),
instr('viola', clef='Alto', minspeed=0.08, polyphony_max_voices=2, polyphony_min_range=3, polyphony_max_range=8, polyphony_minspeed=0.4),
instr('cello', clef='F', minspeed=0.08, polyphony_max_voices=2, polyphony_min_range=3, polyphony_max_range=8, polyphony_minspeed=0.4, technique_switch_delay_map=[('pizz', 'arco', 0.4), ('arco', 'pizz', 0.6)]),
)

DYNAMIC_TO_DECIBEL = {'pp': -30+6, 'p': -25+6, 'mp': -22+6, 'mf': -18+6, 'f': -10+6, 'ff': -6+6}

SEARCH = [
spass('ratio_limit', d('power-seg'), maxratio=1),
#spass('parser', 'noisiness-seg > 0.3', 'closest', [d('mfccs-seg')], [d('f0-seg', norm=1)]),
spass('closest', d('mfccs-seg')),
]




SUPERIMPOSE = si()





BACH_INCLUDE_TARGET = False
#CSOUND_CHANNEL_RENDER_METHOD = "targetoutputmix"
#CSOUND_CHANNEL_RENDER_METHOD = 'oneChannelPerInstrument' # writes each instrument to its own channel in the output sound file.
