TARGET = tsf('beatbox.wav', thresh=-35, minSegLen=0.05, offsetRise=2)


CORPUS = [
csf('bowl/metal-center.wav', instrTag='bowl', midiPitchMethod=77, instrParams={'annotation': 'metal', 'technique': 'm'}),
csf('bowl/metal-center-ds.wav', instrTag='bowl', midiPitchMethod=77, instrParams={'annotation': 'metal', 'articulation': 'staccato', 'technique': 'm'}),
csf('bowl/metal-center-scrape.wav', instrTag='bowl', midiPitchMethod=77, instrParams={'annotation': 'metal', 'notehead': 'x', 'minspeed': 0.4, 'technique': 'm'}),
csf('bowl/metal-side.wav', instrTag='bowl', midiPitchMethod=64, instrParams={'annotation': 'metal', 'technique': 'm'}),
csf('bowl/metal-side-ds.wav', instrTag='bowl', midiPitchMethod=64, instrParams={'annotation': 'metal', 'articulation': 'staccato', 'technique': 'm'}),
csf('bowl/metal-side-scrape.wav', instrTag='bowl', midiPitchMethod=64, instrParams={'annotation': 'metal', 'notehead': 'x', 'minspeed': 0.4, 'technique': 'm'}),
csf('bowl/yarn-center.wav', instrTag='bowl', midiPitchMethod=77, instrParams={'annotation': 'yarn', 'technique': 'y'}),
csf('bowl/yarn-center-ds.wav', instrTag='bowl', midiPitchMethod=77, instrParams={'annotation': 'yarn', 'articulation': 'staccato', 'technique': 'y'}),
csf('bowl/yarn-side.wav', instrTag='bowl', midiPitchMethod=64, instrParams={'annotation': 'yarn', 'technique': 'y'}),
csf('bowl/yarn-side-ds.wav', instrTag='bowl', midiPitchMethod=64, instrParams={'annotation': 'yarn', 'technique': 'y'}),
]


INSTRUMENTS = score(
instr('bowl', clef='Percussion', minspeed=0.075, technique_switch_delay_map=[('m', 'y', 0.5), ('y', 'm', 0.5)]),
instr('bowl', clef='Percussion', minspeed=0.075, technique_switch_delay_map=[('m', 'y', 0.5), ('y', 'm', 0.5)]),
)

SEARCH = [
spass('closest_percent', d('power-seg'), percent=20),
spass('closest', d('centroid-seg')),
]


SUPERIMPOSE = si()

BACH_INCLUDE_TARGET = True
CSOUND_PLAY_RENDERED_FILE = True
#CSOUND_CHANNEL_RENDER_METHOD = "targetoutputmix"